_OpenScript( "includes/vector3.lua" );
MyIndex		=	0; -- Weapon's entity index.
Owner		= 	0; -- The player that owns this weapon
CurrentTime	=	0; -- The current game time

Zoomed = false;

-- This is called when the weapon is given to player	
function onInit( )
_SWEPSetSound( MyIndex, "single_shot", "" )
end

-- This is called every frame
function onThink( )
		
end

-- This is called when the player presses his primary fire button. 
 	function onPrimaryAttack( )	
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
	
	   local vecpos = _PlayerGetShootPos( Owner );
	   local plyang = _PlayerGetShootAng( Owner );
	 
	   _TraceLine( vecpos, plyang, 10000, Owner );
	   
	   local hitpos = _TraceEndPos();
	 
	   if ( _TraceHit() == false )  then
	   
	   hitpos = vecAdd( vecpos, vecMul( plyang, vector3(8000,8000,8000) ) )
	   
	   end
	 
		local C4 = _EntCreate( "prop_physics" );
      local vVelocity = vecMul(  plyang, vector3(1500, 1500, 1500) );		

		if (C4 > 0) then
    _EntPrecacheModel( "models/weapons/w_c4.mdl" )
			_EntSetModel( C4, "models/weapons/w_c4.mdl")
			_EntSetPos( C4,_PlayerGetShootPos( Owner ) );
			_EntSetAng( C4, _PlayerGetShootAng( Owner ) );
			_EntSetOwner(C4, Owner );
			_EntSetAng(C4, _PlayerGetShootAng( Owner ))
         _EntSpawn( C4 );
         _PhysApplyForce( C4, vVelocity );

	 local C4pos = _EntGetPos( C4 )
	 local C4Explode = _EntCreate( "env_explosion" )
   _EntSetKeyValue( C4Explode, "iMagnitude", 1000 )
   _EntSpawn( C4Explode )
   _EntSetPos( C4Explode, C4pos )
   _EntSetParent( C4Explode, C4 ) 
   _EntFire( C4Explode, "Explode", "", 10 )
   _EntFire( C4, "kill", "", 1000 )
   _EntFire(C4, "addoutput", "onhealthchanged !self,kill", 0.9)
	end
	
			
	end 
-- Same as above
function onSecondaryAttack( )		
	
end
	
-- Return true if you want it to reload successfully
function onReload( )

	return ;
end

-- Set this to true if you want the gun on the right side of your view.
-- False if you want it on the left.
function getWeaponSwapHands()
	return false;	
end

-- Sets the player's Field of View while using this weapon.
function getWeaponFOV()
	return 80;	
end


-- Slot number for the new weapon
-- 0 = crowbar/grav gun
-- 1 = pistol/357
-- 2 = smg/pulse rifle
-- 3 = shotgun/crossbow
-- 4 = genade/rpg
-- 5 = bugbait
function getWeaponSlot()
	return 5;	
end

-- Position of weapon in the slot. If it is in the same slot 
-- position of another gun it will not show up.
function getWeaponSlotPos()
	return 4;	
end

-- Just guess what this does.
function getFiresUnderwater()
	return ;
end

-- Reload after every shot? (like the crossbow)
function getReloadsSingly()
	return ;
end

-- how much damage the bullet does
function getDamage()
	return 1;
end

-- Delay between shots (in seconds)
function getPrimaryShotDelay()
	return 0.15;
end

-- Delay between shots for secondary fire (in seconds)
function getSecondaryShotDelay()
	return 0.1;
end

-- Automatic weapon
function getPrimaryIsAutomatic()
	return false;
end

-- Automatic weapon for secondary fire
function getSecondaryIsAutomatic()
	return ;
end

-- Ammo type for primary fire
function getPrimaryAmmoType()
	return "slam";
end

-- Ammo type for secondary fire
function getSecondaryAmmoType()
	return "";
end

-- Max Clip size. -1 if no clip
function getMaxClipPrimary()
	return -1;
end

-- Max Clip size for secondary fire. -1 if no clip
function getMaxClipSecondary()
	return -1;
end

-- Primary Ammo given to player when given the gun
function getDefClipPrimary()
	return -1;
end

-- Secondary Ammo given to player when given the gun
function getDefClipSecondary()
	return -1;
end

-- 0 = Don't override, shoot bullets, make sound and flash
-- 1 = Don't shoot bullets but do make flash/sounds
-- 2 = Only play animations
-- 3 = Don't do anything
function getPrimaryScriptOverride()
	return 1;
end

-- see above
function getSecondaryScriptOverride()
	return 3;
end

-- Higher the # the bigger the spread
function getBulletSpread()

if (zoom) then
	return vector3( 0.0, 0.0, 0.0 );
else
	return vector3( 0.0, 0.0, 0.0 );
end
end

-- amount of view kick
function getViewKick()
	return vector3( 0.0, 0.0, 0.0);
end

-- same as above only random values (set to 0.0 , 0.0, 0.0 for no random kick)
function getViewKickRandom()
	return vector3( 0.0, 0.0, 0.0 );
end

-- Defines the first person model
function getViewModel( )
	return "models/weapons/v_c4.mdl";
end

-- Defines what it looks like from 3rd person view
function getWorldModel( )
	return "models/weapons/w_c4_planted.mdl";
end

-- Classname of wep. So you can use "give" for this
function getClassName()
	return "weapon_C4";
end

-- getAnimPrefix - the animation prefix. one of the following: 
-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
function getAnimPrefix()
	return "slam";
end

-- Text you see when choosing the weapon
function getPrintName()
	return "C4";
end
